<?php
/* --------------------------------------------------------------
  ServiceProvider.php 2020-03-01
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitEan;

use Doctrine\DBAL\Connection;
use Gambio\Core\Application\DependencyInjection\AbstractBootableServiceProvider;
use Gambio\Core\Event\PrioritizingEventListenerProvider;
use Gambio\Shop\Attributes\SellingUnitEan\Listener\OnGetSellingUnitEanEventListener;
use Gambio\Shop\Attributes\SellingUnitEan\Repository\Reader\ReaderDatabase;
use Gambio\Shop\Attributes\SellingUnitEan\Repository\Reader\ReaderInterface;
use Gambio\Shop\Attributes\SellingUnitEan\Repository\Repository;
use Gambio\Shop\Attributes\SellingUnitEan\Repository\RepositoryInterface;
use Gambio\Shop\Attributes\SellingUnitEan\Service\ReadService;
use Gambio\Shop\Attributes\SellingUnitEan\Service\ReadServiceInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\OnGetSellingUnitEanEvent;

/**
 * Class ServiceProvider
 *
 * @package Gambio\Shop\Attributes\SellingUnitEan
 */
class ServiceProvider extends AbstractBootableServiceProvider
{
    public function provides(): array
    {
        return [
            OnGetSellingUnitEanEventListener::class
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function boot(): void
    {
        /** @var PrioritizingEventListenerProvider $prioritizingListenerProvider */
        $prioritizingListenerProvider = $this->application->get(PrioritizingEventListenerProvider::class);
        $prioritizingListenerProvider->attachListener(OnGetSellingUnitEanEvent::class,
                                                      OnGetSellingUnitEanEventListener::class);
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->registerShared(OnGetSellingUnitEanEventListener::class)
            ->addArgument(ReadServiceInterface::class);
        $this->application->registerShared(ReadServiceInterface::class, ReadService::class)
            ->addArgument(RepositoryInterface::class);
        $this->application->registerShared(RepositoryInterface::class, Repository::class)
            ->addArgument(ReaderInterface::class);
        $this->application->registerShared(ReaderInterface::class, ReaderDatabase::class)
            ->addArgument(Connection::class);
    }
}